extends Actor

func _physics_process(delta):
	var direction = get_direction()
	velocity.x = max_velocity.x * direction.x
	if direction.y < -0.5:
		velocity.y = -max_velocity.y
	else:
		velocity.y += gravity * delta
	velocity = move_and_slide(velocity, Vector2.UP)

func get_direction() -> Vector2:
	return Vector2(Input.get_action_strength("move_right") - Input.get_action_strength("move_left"), 
		-1.0 if Input.get_action_strength("jump") and is_on_floor() else 1.0)
	
